<?php

namespace OAuth\Unit\UserData\Extractor;

use OAuth\UserData\Extractor\Linkedin;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-02-09 at 10:22:38.
 */
class LinkedinTest extends \PHPUnit_Framework_TestCase
{
    const PROFILE_RESPONSE =
'{
  "emailAddress": "johnnydonny@gmail.com",
  "firstName": "John",
  "headline": "Frontend Web Developer",
  "id": "ABCDEFGH",
  "industry": "Computer Software",
  "lastName": "Doe",
  "location": {
    "country": {"code": "it"},
    "name": "Rome Area, Italy"
  },
  "memberUrlResources": {
    "_total": 1,
    "values": [{
      "id": 11,
      "name": "Company Website",
      "url": "http://www.johnnydonny.com"
    },
    {
      "id": 12,
      "name": "Blog",
      "url": "http://blog.johnnydonny.com"
    }]
  },
  "pictureUrl": "http://m.c.lnkd.licdn.com/mpr/mprx/someweirdstring",
  "publicProfileUrl": "http://www.linkedin.com/in/johnnydonny",
  "summary": "I am who I am"
}
';

    /**
     * @var Linkedin
     */
    protected $extractor;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->extractor = new Linkedin;
        $service = $this->getMockBuilder('\\OAuth\\OAuth2\\Service\\Linkedin')
            ->disableOriginalConstructor()
            ->getMock();
        $service->expects($this->any())
            ->method('request')
            ->with(Linkedin::createProfileRequestUrl())
            ->will($this->returnValue(LinkedinTest::PROFILE_RESPONSE));
        /**
         * @var \OAuth\Common\Service\ServiceInterface $service
         */
        $this->extractor->setService($service);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    public function testDoesNotSupportUsername()
    {
        $this->assertFalse($this->extractor->supportsUsername());
        $this->assertNull($this->extractor->getUsername());
    }

    public function testGetUniqueId()
    {
        $this->assertEquals('ABCDEFGH', $this->extractor->getUniqueId());
    }

    public function testGetFirstName()
    {
        $this->assertEquals('John', $this->extractor->getFirstName());
    }

    public function testGetLastName()
    {
        $this->assertEquals('Doe', $this->extractor->getLastName());
    }

    public function testGetFullName()
    {
        $this->assertEquals('John Doe', $this->extractor->getFullName());
    }

    public function testGetEmail()
    {
        $this->assertEquals('johnnydonny@gmail.com', $this->extractor->getEmail());
    }

    public function testGetDescription()
    {
        $this->assertEquals('I am who I am', $this->extractor->getDescription());
    }

    public function testGetImageUrl()
    {
        $this->assertEquals('http://m.c.lnkd.licdn.com/mpr/mprx/someweirdstring', $this->extractor->getImageUrl());
    }

    public function testGetProfileUrl()
    {
        $this->assertEquals('http://www.linkedin.com/in/johnnydonny', $this->extractor->getProfileUrl());
    }

    public function testGetLocation()
    {
        $this->assertEquals('Rome Area, Italy', $this->extractor->getLocation());
    }

    public function testGetWebsites()
    {
        $expected = array(
            'http://www.johnnydonny.com',
            'http://blog.johnnydonny.com'
        );
        $this->assertEquals($expected, $this->extractor->getWebsites());
    }

    public function testIsEmailVerified()
    {
        $this->assertTrue($this->extractor->isEmailVerified());
    }

    public function testGetExtras()
    {
        $extras = $this->extractor->getExtras();
        $this->assertArrayHasKey('industry', $extras);
        $this->assertArrayHasKey('headline', $extras);

        $this->assertArrayNotHasKey('id', $extras);
        $this->assertArrayNotHasKey('firstName', $extras);
        $this->assertArrayNotHasKey('lastName', $extras);
    }
}
