<?php

namespace OAuth\Unit\UserData\Exception;

use OAuth\UserData\Exception\UndefinedExtractorException;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-02-08 at 00:28:02.
 */
class UndefinedExtractorExceptionTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var UndefinedExtractorException
     */
    protected $exception;

    protected $service;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->service = $this->getMockBuilder('\\OAuth\\Common\\Service\\ServiceInterface')
            ->setMockClassName('SomeClass')
            ->getMock();
        /**
         * @var \OAuth\Common\Service\ServiceInterface $service
         */
        $service = $this->service;
        $this->exception = new UndefinedExtractorException($service, array('foo', 'bar'));
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    public function testGetService()
    {
        $this->assertSame($this->service, $this->exception->getService());
    }

    public function testGetRegisteredExtractors()
    {
        $this->assertEquals(array('foo', 'bar'), $this->exception->getRegisteredExtractors());
    }

    public function testGetMessageWithCustomMessage()
    {
        $exception = new UndefinedExtractorException($this->service, array(), 'some message');
        $this->assertEquals('some message', $exception->getMessage());
    }
}
