<?php

namespace OAuth\Unit\UserData\Extractor;

use OAuth\UserData\Extractor\ExtractorInterface;
use OAuth\UserData\Extractor\LazyExtractor;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-02-08 at 10:56:49.
 */
class LazyExtractorTest extends \PHPUnit_Framework_TestCase
{

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    public function testLazyLoadGet()
    {
        $loadersMap = array(
            ExtractorInterface::FIELD_UNIQUE_ID => 'id',
            ExtractorInterface::FIELD_USERNAME => 'profile'
        );
        $normalizersMap = array(
            ExtractorInterface::FIELD_UNIQUE_ID => ExtractorInterface::FIELD_UNIQUE_ID,
            ExtractorInterface::FIELD_USERNAME => ExtractorInterface::FIELD_USERNAME
        );
        $supports = array(
            ExtractorInterface::FIELD_UNIQUE_ID,
            ExtractorInterface::FIELD_USERNAME
        );
        $fields = array(
            ExtractorInterface::FIELD_UNIQUE_ID => 123
        );
        $constructorArgs = array(
            $loadersMap,
            $normalizersMap,
            $supports,
            $fields
        );
        $methods = array(
            'idLoader',
            'uniqueIdNormalizer',
            'profileLoader',
            'usernameNormalizer'
        );
        $profileData = array(
            'data' => array(
                'nickname' => 'johnnydonny'
            )
        );
        $extractor = $this->getMockBuilder('\\OAuth\\UserData\\Extractor\\LazyExtractor')
            ->setMethods($methods)
            ->setConstructorArgs($constructorArgs)
            ->getMock();
        $extractor->expects($this->never())
            ->method('idLoader');
        $extractor->expects($this->never())
            ->method('uniqueIdNormalizer');
        $extractor->expects($this->once())
            ->method('profileLoader')
            ->with()
            ->will($this->returnValue($profileData));
        $extractor->expects($this->once())
            ->method('usernameNormalizer')
            ->with($profileData)
            ->will($this->returnValue($profileData['data']['nickname']));
        /**
         * @var \OAuth\UserData\Extractor\LazyExtractor $extractor
         */
        $this->assertEquals(123, $extractor->getUniqueId()); // prefetched field, does not trigger loader and normalizer
        $this->assertEquals('johnnydonny', $extractor->getUsername()); // triggers the loader and the normalizer
        $this->assertEquals('johnnydonny', $extractor->getUsername()); // does not trigger them again
    }

    public function testUnsupportedField()
    {
        $extractor = new LazyExtractor();
        $this->assertNull($extractor->getUniqueId());
    }
}
