<?php 
/**
 * @package Helpers
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 */

/**
 * Functions for use with the C5 dashboard.
 * @package Helpers
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 */

defined('C5_EXECUTE') or die("Access Denied.");
class ConcreteDashboardHelper {

	/** 
	 * Checks to see if a user has access to the C5 dashboard.
	 */
	public function canRead() {
		$c = Page::getByPath('/dashboard', 'ACTIVE');
		$cp = new Permissions($c);
		return $cp->canRead();
	}
	
	
	public function canAccessComposer() {
		$c = Page::getByPath('/dashboard/composer', 'ACTIVE');
		$cp = new Permissions($c);
		return $cp->canRead();
	}

	public function inDashboard($page = false) {
		if (!$page) {
			$page = Page::getCurrentPage();
		}
		return strpos($page->getCollectionPath(), '/dashboard') === 0;
	}
	
	public function getDashboardPaneFooterWrapper($includeDefaultBody = true) {
		$html = '</div></div></div></div>';
		if ($includeDefaultBody) {
			$html .= '</div>';
		}
		return $html;
	}
	
	public function getDashboardPaneHeaderWrapper($title = false, $help = false, $span = 'span16', $includeDefaultBody = true, $navigatePages = array(), $upToPage = false) {
		if (!$span) {
			$span = 'span16';
		}
		$html = '<div class="ccm-ui"><div class="row"><div class="' . $span . '"><div class="ccm-pane">';
		$html .= self::getDashboardPaneHeader($title, $help, $navigatePages, $upToPage);
		if ($includeDefaultBody) {
			$html .= '<div class="ccm-pane-body ccm-pane-body-footer">';
		}
		return $html;
	}
	
	public function getDashboardPaneHeader($title = false, $help = false, $navigatePages = array(), $upToPage = false) {
		$c = Page::getCurrentPage();
		$vt = Loader::helper('validation/token');
		$token = $vt->generate('access_quick_nav');

		$currentMenu = array();
		$nh = Loader::helper('navigation');
		$trail = $nh->getTrailToCollection($c);
		if (count($trail) > 1 || count($navigatePages) > 1 || is_object($upToPage)) { 
			$parent = Page::getByID($c->getCollectionParentID());
			if (count($trail) > 2 && (!is_object($upToPage))) {
				$upToPage = Page::getByID($parent->getCollectionParentID());
			}
			Loader::block('autonav');
			if (count($navigatePages) > 0) { 
				$subpages = $navigatePages;
			} else { 
				$subpages = AutonavBlockController::getChildPages($parent);
			}
			
			$subpagesP = array();
			foreach($subpages as $sc) {
				$cp = new Permissions($sc);
				if ($cp->canRead()) { 
					$subpagesP[] = $sc;
				}
			}
			
			if (count($subpagesP) > 0 || is_object($upToPage)) { 
				$relatedPages = '<div id="ccm-page-navigate-pages-content" style="display: none">';
				$relatedPages .= '<ul class="ccm-navigate-page-menu">';
		
				foreach($subpagesP as $sc) { 
		
					if ($c->getCollectionPath() == $sc->getCollectionPath() || (strpos($c->getCollectionPath(), $sc->getCollectionPath()) == 0) && strpos($c->getCollectionPath(), $sc->getCollectionPath()) !== false) {
						$class= 'nav-selected';
					} else {
						$class = '';
					}
					
					$relatedPages .= '<li class="' . $class . '"><a href="' . $nh->getLinkToCollection($sc) . '">' . $sc->getCollectionName() . '</a></li>';
				}
		
				if ($upToPage) { 
					$relatedPages .= '<li class="ccm-menu-separator"></li>';
					$relatedPages .= '<li><a href="' . $nh->getLinkToCollection($upToPage) . '">' . t('&lt; Back to %s', $upToPage->getCollectionName()) . '</a></li>';
				}
				$relatedPages .= '</ul>';
				$relatedPages .= '</div>';
				$navigateTitle = $parent->getCollectionName();
			}
		}
		

		$html = '<div class="ccm-pane-header">';
		
		$html .= $relatedPages;
		
		$class = 'ccm-icon-favorite';
		$u = new User();
		$quicknav = unserialize($u->config('QUICK_NAV_BOOKMARKS'));
		if (is_array($quicknav)) {
			if (in_array($c->getCollectionID(), $quicknav)) {
				$class = 'ccm-icon-favorite-selected';	
			}
		}
		$html .= '<ul class="ccm-pane-header-icons">';
		if (!$help) {
			$ih = Loader::helper('concrete/interface/help');
			$pageHelp = $ih->getPages();
			if (isset($pageHelp[$c->getCollectionPath()])) {
				$help = $pageHelp[$c->getCollectionPath()];
			}
		}
		
		if (is_array($help)) {
			$help = $help[0] . '<br/><br/><a href="' . $help[1] . '" class="btn small" target="_blank">' . t('Learn More') . '</a>';
		}
		
		if (isset($relatedPages)) { 
			$html .= '<li><a href="javascript:void(0)" onmouseover="ccm_togglePopover(event, this)" class="ccm-icon-navigate-pages" title="' . $navigateTitle . '" id="ccm-page-navigate-pages">' . t('Help') . '</a></li>';
		}
		
		if ($help) {
			$html .= '<li><span style="display: none" id="ccm-page-help-content">' . $help . '</span><a href="javascript:void(0)" onclick="ccm_togglePopover(event, this)" class="ccm-icon-help" title="' . t('Help') . '" id="ccm-page-help">' . t('Help') . '</a></li>';
		}
		$html .= '<li><a href="javascript:void(0)" id="ccm-add-to-quick-nav" onclick="ccm_toggleQuickNav(' . $c->getCollectionID() . ',\'' . $token . '\')" class="' . $class . '">' . t('Add to Favorites') . '</a></li>';
		$html .= '<li><a href="javascript:void(0)" onclick="ccm_closeDashboardPane(this)" class="ccm-icon-close">' . t('Close') . '</a></li>';
		$html .= '</ul>';
		if (!$title) {
			$title = $c->getCollectionName();
		}
		$html .= '<h3>' . $title . '</h3>';
		$html .= '</div>';
		return $html;
	}
	
	public function getDashboardBackgroundImage() {
		$feed = array();
		// this feed is an array of standard PHP objects with a SRC, a caption, and a URL
		// allow for a custom white-label feed
		$filename = date('Ymd') . '.jpg';
		$obj = new stdClass;
		$obj->checkData = false;
		
		if (defined('WHITE_LABEL_DASHBOARD_BACKGROUND_FEED') && WHITE_LABEL_DASHBOARD_BACKGROUND_FEED != '') {
			$image = WHITE_LABEL_DASHBOARD_BACKGROUND_FEED . '/' . $filename;
		} else if (defined('WHITE_LABEL_DASHBOARD_BACKGROUND_SRC') && WHITE_LABEL_DASHBOARD_BACKGROUND_SRC != '') {
			$image = WHITE_LABEL_DASHBOARD_BACKGROUND_SRC;
		} else {
			$image = DASHBOARD_BACKGROUND_FEED . '/' . $filename;
			$obj->checkData = true;
		}
		$obj->filename = $filename;
		$obj->image = $image;
		return $obj;
	}

	public function getDashboardAndSearchMenus() {
		if (isset($_SESSION['dashboardMenus'])) {
			return $_SESSION['dashboardMenus'];
		}
		
		ob_start(); ?>
			<div id="ccm-intelligent-search-results">
			<?php 
			$page = Page::getByPath('/dashboard');
			$children = $page->getCollectionChildrenArray(true);
			
			$packagepages = array();
			$corepages = array();
			foreach($children as $ch) {
				$page = Page::getByID($ch);
				$pageP = new Permissions($page);
				if ($pageP->canRead()) { 
					if (!$page->getAttribute("exclude_nav")) {
						if ($page->getPackageID() > 0) {
							$packagepages[] = $page;
						} else {
							$corepages[] = $page;
						}
					}
				}
			
				if ($page->getAttribute('exclude_search_index')) {
					continue;
				}
				
				if ($page->getCollectionPath() == '/dashboard/system') {
					$ch2 = $page->getCollectionChildrenArray();
				} else {
					$ch2 = $page->getCollectionChildrenArray(true);
				}
				?>
				
				<div class="ccm-intelligent-search-results-module ccm-intelligent-search-results-module-onsite">
				
				<h1><?php echo t($page->getCollectionName())?></h1>
				
				
				<ul class="ccm-intelligent-search-results-list">
				<?php  if (count($ch2) == 0) { ?>
					<li><a href="<?php echo Loader::helper('navigation')->getLinkTocollection($page)?>"><?php echo t($page->getCollectionName())?></a><span><?php echo t($page->getCollectionName())?> <?php echo $page->getAttribute('meta_keywords')?></span></li>
				<?php  } ?>
				
				<?php 
				if ($page->getCollectionPath() == '/dashboard/system') { ?>
					<li><a href="<?php echo Loader::helper('navigation')->getLinkTocollection($page)?>"><?php echo t('View All')?><span><?php echo t($page->getCollectionName())?> <?php echo $page->getAttribute('meta_keywords')?></span></li>
				<?php 				
				}
				
				foreach($ch2 as $chi) {
					$subpage = Page::getByID($chi); 
					$subpageP = new Permissions($subpage);
					if (!$subpageP->canRead()) {
						continue;
					}

					if ($subpage->getAttribute('exclude_search_index')) {
						continue;
					}
			
					?>
					<li><a href="<?php echo Loader::helper('navigation')->getLinkTocollection($subpage)?>"><?php echo $subpage->getCollectionName()?></a><span><?php  if ($page->getCollectionPath() != '/dashboard/system') { ?><?php echo t($page->getCollectionName())?> <?php echo $page->getAttribute('meta_keywords')?> <?php  } ?><?php echo $subpage->getCollectionName()?> <?php echo $subpage->getAttribute('meta_keywords')?></span></li>
					<?php  
				}
				?>
				</ul>
				
				</div>
				<?php  } ?>
				
				<div class="ccm-intelligent-search-results-module ccm-intelligent-search-results-module-onsite">
				
				<h1><?php echo t('Dashboard Home')?></h1>
				
				
				<ul class="ccm-intelligent-search-results-list">
					<li><a href="<?php echo View::url('/dashboard/home')?>"><?php echo t('Customize')?> <span><?php echo ('Customize Dashboard Home')?></span></a></li>
				</ul>
				
				</div>

				<div class="ccm-intelligent-search-results-module ccm-intelligent-search-results-module-loading">
				<h1><?php echo t('Your Site')?></h1>
				<ul class="ccm-intelligent-search-results-list" id="ccm-intelligent-search-results-list-your-site">
				</ul>
				</div>
				
				<?php  if (ENABLE_INTELLIGENT_SEARCH_HELP) { ?>
				<div class="ccm-intelligent-search-results-module ccm-intelligent-search-results-module-offsite ccm-intelligent-search-results-module-loading">
				<h1><?php echo t('Help')?></h1>
				<ul class="ccm-intelligent-search-results-list" id="ccm-intelligent-search-results-list-help">
				</ul>
				</div>
				<?php  } ?>
				
				<?php  if (ENABLE_INTELLIGENT_SEARCH_MARKETPLACE) { ?>
				<div class="ccm-intelligent-search-results-module ccm-intelligent-search-results-module-offsite ccm-intelligent-search-results-module-loading">
				<h1><?php echo t('Add-Ons &amp; Themes')?></h1>
				<ul class="ccm-intelligent-search-results-list" id="ccm-intelligent-search-results-list-marketplace">
				</ul>
				</div>
				<?php  } ?>				
			</div>
			
			<div id="ccm-dashboard-overlay">
			<div id="ccm-dashboard-overlay-core">
			<div class="ccm-dashboard-overlay-inner" id="ccm-dashboard-overlay-main">
			
			<?php 
			
			foreach($corepages as $page) {

				?>
				
				<div class="ccm-dashboard-overlay-module">
				
				<h1><a href="<?php echo Loader::helper('navigation')->getLinkToCollection($page)?>"><?php echo t($page->getCollectionName())?></a></h1>
				
				
				<ul>
				
				<?php 
				$ch2 = $page->getCollectionChildrenArray(true);
				foreach($ch2 as $chi) {
					$subpage = Page::getByID($chi); 
					$subpageP = new Permissions($subpage);
					if (!$subpageP->canRead()) {
						continue;
					}

					if ($subpage->getAttribute('exclude_nav')) {
						continue;
					}
			
					?>
					<li><a href="<?php echo Loader::helper('navigation')->getLinkToCollection($subpage)?>"><?php echo t($subpage->getCollectionName())?></a></li>
					<?php  
				}
				?>
				</ul>
				
				</div>
				
				<?php 
			}
				
			?>
			
			
			</div>
			</div>
			<div id="ccm-dashboard-overlay-misc" <?php  if (count($packagepages) == 0)  { ?>class="ccm-dashboard-overlay-misc-rounded" <?php  } ?>>
			<div class="ccm-dashboard-overlay-inner">
			<ul>
			<li><a href="<?php echo View::url('/dashboard')?>"><strong><?php echo t('News')?></strong></a> – <?php echo t('Learn about your site and concrete5')?></li>
			<li><a href="<?php echo View::url('/dashboard/system')?>"><strong><?php echo t('System &amp; Settings')?></strong></a> – <?php echo t('Secure and setup your site.')?></li>
			<li><a href="<?php  echo View::url('/dashboard/extend') ?>"><strong><?php  echo t("Extend concrete5") ?></strong></a> – 
			<?php  echo sprintf(t('<a href="%s">Install</a>, <a href="%s">update</a> or download more <a href="%s">themes</a> and <a href="%s">add-ons</a>.'),
				View::url('/dashboard/extend/install'),
				View::url('/dashboard/extend/update'),
				View::url('/dashboard/extend/themes'),
				View::url('/dashboard/extend/add-ons')); ?>
			</li>
			</ul>
			</div>
			</div>
			<?php  if (count($packagepages) > 0) { ?>
			<div id="ccm-dashboard-overlay-footer">
			<div class="ccm-dashboard-overlay-inner" id="ccm-dashboard-overlay-packages">
			<?php 
			
			
			foreach($packagepages as $page) {
				?>
				
				<div class="ccm-dashboard-overlay-module">
				
				<h1><a href="<?php echo Loader::helper('navigation')->getLinkToCollection($page)?>"><?php echo t($page->getCollectionName())?></a></h1>
				
				
				<ul>
				
				<?php 
				$ch2 = $page->getCollectionChildrenArray(true);
				foreach($ch2 as $chi) {
					$subpage = Page::getByID($chi); 
					if ($subpage->getAttribute('exclude_nav')) {
						continue;
					}
					
					?>
					<li><a href="<?php echo Loader::helper('navigation')->getLinkToCollection($subpage)?>"><?php echo t($subpage->getCollectionName())?></a></li>
					<?php  
				}
				?>
				</ul>
				
				</div>
				
				<?php 
			}
				
			?>
			</div>
			</div>
			<?php  } ?>
			</div>
		<?php 
			$contents = ob_get_contents();
			ob_end_clean();
			return str_replace(array("\n", "\r", "\t"), "", $contents);
	
	}
}