ccm_marketplaceLauncherOpenPost = function() {

	jQuery.fn.dialog.hideLoader();
	// highlight the first addon
	ccm_marketplaceBrowserInit();
	$(".ccm-pagination a").click(function() {
		jQuery.fn.dialog.showLoader(false);
		$('#newsflow-overlay').load($(this).attr('href'), function() {
			ccm_marketplaceLauncherOpenPost();			
		});
		return false;
	});
	
	$("#ccm-marketplace-browser-form").ajaxForm({
		beforeSubmit: function() {
			jQuery.fn.dialog.showLoader(false);
		},
		success: function(r) {
			$('#newsflow-overlay').html(r);
			ccm_marketplaceLauncherOpenPost();
		}
	});
}

ccm_openThemeLauncher = function(mpID, closeTop) {
	jQuery.fn.dialog.closeTop();
	params = {'mpID': mpID};
	jQuery.fn.dialog.showLoader(ccmi18n.themeBrowserLoading);
	$.getJSON(CCM_TOOLS_PATH + '/marketplace/connect', params, function(resp) {
		if (resp.isConnected) {
	
			var mpIDstr = '';
			if (mpID) {
				mpIDstr = '&mpID=' + mpID;
			}

			jQuery.fn.dialog.closeTop();
			
			ccm_showNewsflowOverlayWindow(CCM_DISPATCHER_FILENAME + '/dashboard/extend/themes?_ccm_dashboard_external=1' + mpIDstr, function() {
				ccm_marketplaceLauncherOpenPost();
			});

		} else {
			$.fn.dialog.open({
				title: ccmi18n.community,
				href:  CCM_TOOLS_PATH + '/marketplace/frame?task=open_theme_launcher&mpID=' + mpID,
				width: '90%',
				modal: false,
				height: '70%'
			});
		}
	});
}

ccm_openAddonLauncher = function(mpID, closeTop) {
	jQuery.fn.dialog.closeTop();
	params = {'mpID': mpID};
	$("#ccm-intelligent-search-results").hide();

	jQuery.fn.dialog.showLoader(ccmi18n.addonBrowserLoading);	
	$.getJSON(CCM_TOOLS_PATH + '/marketplace/connect', params, function(resp) {
		if (resp.isConnected) {
			$("#ccm-nav-intelligent-search").val('');
			$("#ccm-intelligent-search-results").fadeOut(90, 'easeOutExpo');

			var mpIDstr = '';
			if (mpID) {
				mpIDstr = '&mpID=' + mpID;
			}
		
			jQuery.fn.dialog.closeTop();
			
			ccm_showNewsflowOverlayWindow(CCM_DISPATCHER_FILENAME + '/dashboard/extend/add-ons?_ccm_dashboard_external=1' + mpIDstr, function() {
				ccm_marketplaceLauncherOpenPost();
			});
		} else {
			$.fn.dialog.open({
				title: ccmi18n.community,
				href:  CCM_TOOLS_PATH + '/marketplace/frame?task=open_addon_launcher&mpID=' + mpID,
				width: '90%',
				modal: false,
				height: '70%'
			});
		}
	});
}

ccm_marketplaceBrowserInit = function() {
	$(".ccm-marketplace-item").click(function() {
		window.scrollTo(0,0);
		/*
		$(".newsflow-paging-previous").hide();
		$(".newsflow-paging-next").hide();
		*/
		$("#ccm-marketplace-detail-inner").hide();
		$('.ccm-marketplace-detail-loading').show();	

		var mpID = $(this).attr('mpID');
		$('.ccm-marketplace-item-selected').removeClass('ccm-marketplace-item-selected').addClass('ccm-marketplace-item-unselected');
		$(this).removeClass('ccm-marketplace-item-unselected').addClass('ccm-marketplace-item-selected');
		$('#ccm-marketplace-detail').show();
		$('#ccm-marketplace-detail-inner').load(CCM_TOOLS_PATH + '/marketplace/details', {
			'mpID': mpID
		}, function() {
			ccm_marketplaceGetDetailPost();
		});
	});

	$("td.ccm-marketplace-item-selected").click();
}

ccm_marketplaceBrowserSelectPrevious = function() {
	var items = $('.ccm-marketplace-item');
	var doSelect = false;
	var foundSomething = false;
	$(items.get().reverse()).each(function() {
		if (doSelect) {
			$(this).click();
			doSelect = false;
			foundSomething = true;
		} else { 
			if ($(this).hasClass('ccm-marketplace-item-selected')) {
				doSelect = true;
			}
		}
	});
	if (!foundSomething) {
		var href = $("#ccm-marketplace-browse-footer li.prev a").first().attr('href');
		href = href + '&prev=1';
		if ($('.newsflow').length > 0) { 
			jQuery.fn.dialog.showLoader(false);
			$('#newsflow-overlay').load(href, function() {
				ccm_marketplaceLauncherOpenPost();			
			});
		} else { 
			window.location.href = href;
		}
	}
}

ccm_marketplaceBrowserSelectNext = function() {
	var items = $('.ccm-marketplace-item');
	var doSelect = false;
	var foundSomething = false;
	items.each(function() {
		if (doSelect) {
			$(this).click();
			doSelect = false;
			foundSomething = true;
		} else { 
			if ($(this).hasClass('ccm-marketplace-item-selected')) {
				doSelect = true;
			}
		}
	});
	
	// if we make it down here...
	if (!foundSomething) {
		var href = $("#ccm-marketplace-browse-footer li.next a").first().attr('href');
		if ($('.newsflow').length > 0) { 
			jQuery.fn.dialog.showLoader(false);
			$('#newsflow-overlay').load(href, function() {
				ccm_marketplaceLauncherOpenPost();			
			});
		} else { 
			window.location.href = href;
		}
	}
}

ccm_marketplaceBrowserSetupNextAndPrevious = function() {

	if ($('.ccm-marketplace-item-selected').attr('mpID') == $('.ccm-marketplace-item').first().attr('mpID') 
	&& $('#ccm-marketplace-browse-footer li.prev a').length == 0) { 
		$(".newsflow-paging-previous").hide();
	} else {
		$(".newsflow-paging-previous").show();
	}

	if ($('.ccm-marketplace-item-selected').attr('mpID') == $('.ccm-marketplace-item').last().attr('mpID')
	&& $('#ccm-marketplace-browse-footer li.next a').length == 0) { 
		$(".newsflow-paging-next").hide();
	} else {
		$(".newsflow-paging-next").show();
	}

	var h = $('#ccm-marketplace-detail').height();
	$(".newsflow-paging-previous span, .newsflow-paging-next span").css('height', h + 'px');
	$(".newsflow-paging-previous, .newsflow-paging-next").css('height', h + 'px');
	
}

ccm_marketplaceGetDetailPost = function() {
	$('.ccm-marketplace-detail-loading').hide();
	$("#ccm-marketplace-detail-inner").show();
	if ($(".ccm-marketplace-item-information-inner").height() < 325) {
		$(".ccm-marketplace-item-information-more").hide();
	}
	$("#ccm-marketplace-item-screenshots").nivoSlider({
		'controlNav': false,
		'effect': 'fade',
		'pauseOnHover': false,
		'directionNav': false
	});
	ccm_setNewsflowPagingArrowHeight();
}

ccm_getMarketplaceItem = function(args) {
	var mpID = args.mpID;
	var closeTop = args.closeTop;
	
	this.onComplete = function() { }

	if (args.onComplete) {
		ccm_getMarketplaceItem.onComplete = args.onComplete;
	}
	
	if (closeTop) {
		jQuery.fn.dialog.closeTop(); // this is here due to a weird safari behavior
	}
	jQuery.fn.dialog.showLoader();
	// first, we check our local install to ensure that we're connected to the
	// marketplace, etc..
	params = {'mpID': mpID};
	$.getJSON(CCM_TOOLS_PATH + '/marketplace/connect', params, function(resp) {
		jQuery.fn.dialog.hideLoader();
		if (resp.isConnected) {
			if (!resp.purchaseRequired) {
				$.fn.dialog.open({
					title: ccmi18n.community,
					href:  CCM_TOOLS_PATH + '/marketplace/download?install=1&mpID=' + mpID,
					width: 350,
					modal: false,
					height: 240
				});
			} else {
				$.fn.dialog.open({
					title: ccmi18n.communityCheckout,
					iframe: true,
					href:  CCM_TOOLS_PATH + '/marketplace/checkout?mpID=' + mpID,
					width: '560px',
					modal: false,
					height: '400px'
				});
			}

		} else {
			$.fn.dialog.open({
				title: ccmi18n.community,
				href:  CCM_TOOLS_PATH + '/marketplace/frame?task=get&mpID=' + mpID,
				width: '90%',
				modal: false,
				height: '70%'
			});
		}
	});
}