<?php 
defined('C5_EXECUTE') or die(_("Access Denied."));
Loader::model('file_list');
Loader::model('file_set');
class DashboardFilesSearchController extends Controller {

	public function view() {
		$html = Loader::helper('html');
		$form = Loader::helper('form');
		$this->set('form', $form);
		$this->addHeaderItem('<script type="text/javascript">$(function() { ccm_activateFileManager(\'DASHBOARD\'); });</script>');
		$fileList = $this->getRequestedSearchResults();
		$files = $fileList->getPage();
				
		$this->set('fileList', $fileList);		
		$this->set('files', $files);		
		$this->set('pagination', $fileList->getPagination());
		

	}
	
	public function getRequestedSearchResults() {
		$fileList = new FileList();
		$keywords = htmlentities($_GET['fKeywords'], ENT_QUOTES, APP_CHARSET);
		$fileList->sortBy('fvDateAdded', 'desc');
		Loader::model('file_set');
		
		if ($keywords != '') {
			$fileList->filterByKeywords($keywords);
		}

		if ($_REQUEST['numResults']) {
			$fileList->setItemsPerPage($_REQUEST['numResults']);
		}
		
		if (isset($_GET['fsIDNone']) && $_GET['fsIDNone'] == 1) { 
			$fileList->filterBySet(false);
		} else {
			if (is_array($_GET['fsID'])) {
				foreach($_GET['fsID'] as $fsID) {
					$fs = FileSet::getByID($fsID);
					$fileList->filterBySet($fs);
				}
			} else if (isset($_GET['fsID']) && $_GET['fsID'] != '' && $_GET['fsID'] > 0) {
				$set = $_REQUEST['fsID'];
				$fs = FileSet::getByID($set);
				$fileList->filterBySet($fs);
			}
		}
		
		if (isset($_GET['fType']) && $_GET['fType'] != '') {
			$type = $_REQUEST['fType'];
			$fileList->filterByType($type);
		}

		if (isset($_GET['fExtension']) && $_GET['fExtension'] != '') {
			$ext = $_REQUEST['fExtension'];
			$fileList->filterByExtension($ext);
		}
		
		$selectedSets = array();

		if (is_array($_REQUEST['selectedSearchField'])) {
			foreach($_REQUEST['selectedSearchField'] as $i => $item) {
				// due to the way the form is setup, index will always be one more than the arrays
				if ($item != '') {
					switch($item) {
						case "extension":
							$extension = $_REQUEST['extension'];
							$fileList->filterByExtension($extension);
							break;
						case "type":
							$type = $_REQUEST['type'];
							$fileList->filterByType($type);
							break;
						case "date_added":
							$dateFrom = $_REQUEST['date_from'];
							$dateTo = $_REQUEST['date_to'];
							if ($dateFrom != '') {
								$dateFrom = date('Y-m-d', strtotime($dateFrom));
								$fileList->filterByDateAdded($dateFrom, '>=');
								$dateFrom .= ' 00:00:00';
							}
							if ($dateTo != '') {
								$dateTo = date('Y-m-d', strtotime($dateTo));
								$dateTo .= ' 23:59:59';
								
								$fileList->filterByDateAdded($dateTo, '<=');
							}
							break;

						case "size":
							$from = $_REQUEST['size_from'];
							$to = $_REQUEST['size_to'];
							$fileList->filterBySize($from, $to);
							break;
						default:
							Loader::model('file_attributes');
							$akID = $item;
							$fak = FileAttributeKey::get($akID);
							$type = $fak->getAttributeType();
							$cnt = $type->getController();
							$cnt->setAttributeKey($fak);
							$cnt->searchForm($fileList);
							break;
					}
				}
			}
		}
		return $fileList;
	}
}

?>